#!/bin/sh

# load the network configuration file
if [ -r /cfg/network.conf ]; then
    echo "load /cfg/network.conf file."
    . /cfg/network.conf
fi

use_vlan=0

# configure VLAN
if [ ${voice_vid} -ne 0 -o ${data_vid} -ne 0 ]; then
	echo "Start VLAN config"

	use_vlan=1
	
	echo 1 > /sys/bus/i2c/devices/0-005f/vlan_enable
 
	echo ${data_vid} > /sys/bus/i2c/devices/0-005f/port1/vlan_id
	echo ${voice_vid} > /sys/bus/i2c/devices/0-005f/port2/vlan_id
#	echo ${voice_vid} > /sys/bus/i2c/devices/0-005f/port1/vlan_id
#	echo ${data_vid} > /sys/bus/i2c/devices/0-005f/port2/vlan_id
#	echo 1 > /sys/bus/i2c/devices/0-005f/port1/vlan_id
#	echo 2 > /sys/bus/i2c/devices/0-005f/port2/vlan_id
	echo 235 > /sys/bus/i2c/devices/0-005f/port3/vlan_id
 
	echo ${voice_vid},${data_vid} > /sys/bus/i2c/devices/0-005f/port1/vlan_memberships
	echo ${voice_vid},${data_vid} > /sys/bus/i2c/devices/0-005f/port2/vlan_memberships
	echo ${voice_vid},${data_vid},235 > /sys/bus/i2c/devices/0-005f/port3/vlan_memberships
#	echo 1,2 > /sys/bus/i2c/devices/0-005f/port1/vlan_memberships
#	echo 1,2 > /sys/bus/i2c/devices/0-005f/port2/vlan_memberships
#	echo 1,2,3 > /sys/bus/i2c/devices/0-005f/port3/vlan_memberships
 
	echo 1 > /sys/bus/i2c/devices/0-005f/port1/vlan_tag_insert
	echo 1 > /sys/bus/i2c/devices/0-005f/port2/vlan_tag_insert
 
	ifconfig eth0 up
	vconfig add eth0 ${voice_vid}
	vconfig add eth0 ${data_vid}
 
	echo "VLAN config finished!"
	
fi

# configure the WAN port interface
case ${ip_type} in
0)
    echo "start static IP mode..."
    killall -9 udhcpc 
    if [ ${use_vlan} -eq 0 ]; then
    	ifconfig eth0 ${ip} netmask ${subnet_mask}
    else
    	ifconfig eth0.${voice_vid} ${ip} netmask ${subnet_mask}
    fi
    echo "ifconfig eth0 ${ip} netmask ${subnet_mask}"

    route add default gw ${router_ip}
    echo "route add default gw ${router_ip}"
    ;;
1)
    echo "start DHCP mode..."
    killall -9 udhcpc
    if [ ${use_vlan} -eq 0 ]; then
	udhcpc &
    else
	udhcpc -i eth0.${voice_vid} &   
    fi
    ;;
esac

sleep 4

if [ ${dns_type} -eq 0 ]
then
    echo "use manual DNS server"
    if [ ! -r /etc/resolv.conf ]; then
        touch /etc/resolv.conf
    fi
    
    cat /dev/null > /etc/resolv.conf
    echo "nameserver ${dns_ip}"  >> /etc/resolv.conf
    echo "nameserver ${dns_ip2}" >> /etc/resolv.conf
    cat /etc/resolv.conf
fi

echo "network config finished."

