#!/bin/sh

# load the network configuration file
if [ -r /cfg/network.conf ]; then
    echo "load /cfg/network.conf file."
    . /cfg/network.conf
fi

# configure the WAN port interface
case ${ip_type} in
0)
    echo "start static IP mode..."
    killall -9 udhcpc 
    ifconfig eth0 ${ip} netmask ${subnet_mask}
    echo "ifconfig eth0 ${ip} netmask ${subnet_mask}"

    route add default gw ${router_ip}
    echo "route add default gw ${router_ip}"
    ;;
1)
    echo "start DHCP mode..."
    killall -9 udhcpc
    /sbin/udhcpc &
    ;;
esac

if [ ${dns_type} -eq 0 ]
then
    echo "use manual DNS server"
    if [ ! -r /etc/resolv.conf ]; then
        touch /etc/resolv.conf
    fi
    
    cat /dev/null > /etc/resolv.conf
    echo "nameserver ${dns_ip}"  >> /etc/resolv.conf
    echo "nameserver ${dns_ip2}" >> /etc/resolv.conf
    cat /etc/resolv.conf
fi

echo "network config finished."

